/**
 * @file main.cpp
 * @brief Application main for the ClassWrite application
 *
 * @date 06/04/2006
 * @author Paul Chana
 * @version 1.0.0 Initial version
 *
 * @note All contents of this source code are copyright 2007 Exp Digital Uk.\n
 * This file forms part of the example projects for the Infinity API.\n
 * You may not redistribute either the source code or the compiled binary.\n
 * The Infinity API is covered by a fair use licence which you should have recieved with this\n
 * file. If you didnt receieve the licence, please contact us via http://www.expdigital.co.uk
 *
 * $Id: main.cpp,v 1.5 2007/02/11 02:20:05 paul Exp $
 */

#include <ECore.h>
#include <EGUI.h>
#include "CClassWriterWindow.hpp"
using Exponent::ClassWrite::CClassWriterWindow;
using namespace Exponent;

#ifdef WIN32
/**
 * @fn int APIENTRY _tWinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow)
 * @brief Entry point to SCal
 * @param hInstance The program instance
 * @param hPrevInstance Usually null, ignored
 * @param lpCmdLine Command line arguments
 * @param nCmdShow The show command
 * @retval int Returns 0
 */
int APIENTRY _tWinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow)
#else
/**
 * @fn int main(int argc, char *argv[])
 * @param argc The argument count
 * @param argv The arguments
 * @retval int Returns 0
 */
int main(int argc, char *argv[])
#endif
{
	/*
	 * Start the API
	 * This will correctly initialise any API wide statics. You *must* *always* call this when you startup an application or DLL, and there *must* be a
	 * corresponding call to STOP_EXPONENT_API when you finish running your application
	 */
#ifdef WIN32
	START_EXPONENT_API(hInstance, "Exponent", "ClassWrite", "Writes Exponent API classes for you", "1.0", "Software//Exponent//ClassWrite", "2006 Exponent Digital");
#else
	START_EXPONENT_API("Exponent", "ClassWrite", "Writes Exponent API classes for you", "1.0", "com.exponent.ClassWrite", "2006 Exponent Digital");
#endif

	// Construct our window
	CWindowAttributes attributes;

#ifdef WIN32
	attributes.initialise(CWindowAttributes::e_noMaximiseNoSize);
#else
	attributes.initialise(CWindowAttributes::e_noMaximiseNoSizeNoClose);
#endif
	attributes.setWindowTitle("Exponent Class Write");
	attributes.setBackgroundColour(CColour(160, 160, 174));

	const long width  = CDisplayInformation::getMonitorScreenWidth()  / 2;
	const long height = CDisplayInformation::getMonitorScreenHeight() / 2;

	CRect windowRect(width  - 210, height - 150, 410, 225);

#ifdef WIN32
	/*
	 * Windows wont size the window properly if you create a window with a title bar etc. Use this function to size it properly
	 */
	CDimension dimension;
	CWindowTools::computeCorrectedWindowArea(CDimension(410, 225), dimension, attributes.getWindowStyle(), attributes.getWindowStyleEx());
	windowRect.setDimensions(dimension);
#endif

	unsigned long returnValue = 0;

	try
	{
		// To ensure TAutomaticPointer is deleted before exit, to clear the Exponent logs up
		TAutomaticPointer<CClassWriterWindow> myWindow = new CClassWriterWindow(windowRect);

		// initialise the window
		myWindow->initialiseWindow(&attributes, true);

		// Store the window -> This enables us to have automatic exiting of the windowing code.
		// During close the window will check if it is the system window, if it is the appliucation is closed down properly automagically
		CApplication::setApplicationWindow(myWindow.getMutablePointer());

		// Startup the application loop
		returnValue = CApplication::runApplicationEventLoop();

	}
	catch (const CException &myException)
	{
		CString message = "Caught and exception. More details below\n\n";
		message.appendString(myException.getErrorReason());
		message.appendString("\n\nIn the function\n\n");
		message.appendString(myException.getFunctionName());
		CDialog::notifyUser(message, "Exception occurred!", true);
	}
	catch (...)
	{
		CDialog::notifyUser("Caught an unknown exception!", "Exception occurred!", true);
	}

	/*
	 * Stop the API. You can also supply this macro with a log path that allows you to see a complete list of all constructed object, their current construction counts
	 * deletion counts and overall number created
	 */
	STOP_EXPONENT_API_NO_LOG;

	// We are done
	return 0;
}